%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    Field computation in postprocessing of the MoM solution


function [E,unitE,Emag] = fieldE(EPS0,x0,y0,z0,rhos,S,x,y,z)
if nargin == 7
    r = sqrt((x0-x).^2 + y0^2 + z0^2);
    E = [(x0-x)./r.^3; y0./r.^3; z0./r.^3]*(rhos.*S'/(4*pi*EPS0));
end;
if nargin == 8
     r = sqrt((x0-x).^2 + (y0-y).^2 + z0^2);
     E = [(x0-x)./r.^3; (y0-y)./r.^3; z0./r.^3]*(rhos.*S'/(4*pi*EPS0));
end;
if nargin == 9
     r = sqrt((x0-x).^2 + (y0-y).^2 + (z0-z).^2);
     E = [(x0-x)./r.^3; (y0-y)./r.^3; (z0- z)./r.^3]*(rhos.*S'/(4*pi*EPS0));
end;
  Emag = vectorMag(E);
  unitE = E/Emag;